
-- Cleans up de-normalised records which have become disconnected
-- as a result of deleting records from table CreoleRuleSet.

-- Attribute inheritance
DELETE FROM CREOLEATTRIBUTEINHERITANCE
WHERE ancestorAttrAvailabilityID IN (
  -- the unlinked availability records
  SELECT creoleAttributeAvailabilityID FROM creoleAttributeAvailability WHERE creoleRuleClassID IN (
    -- disconnected class IDs
    SELECT creoleRuleClassID FROM CreoleRuleClass WHERE creoleRulesetID not IN (SELECT creoleRuleSetID FROM CreoleRuleset) ) )
OR descendantAttrAvailabilityID IN (
  -- the unlinked availability records
  SELECT creoleAttributeAvailabilityID FROM creoleAttributeAvailability WHERE creoleRuleClassID IN (
    -- disconnected class IDs
    SELECT creoleRuleClassID FROM CreoleRuleClass WHERE creoleRulesetID not IN (SELECT creoleRuleSetID FROM CreoleRuleset) ) );

-- Class Inheritance
DELETE FROM CreoleRuleClassInheritance
WHERE ancestorClassID IN (
    -- disconnected class IDs
    SELECT creoleRuleClassID FROM CreoleRuleClass WHERE creoleRuleSetID not IN (SELECT creoleRuleSetID FROM CreoleRuleset))
 OR descendantClassID IN (
    -- disconnected class IDs
    SELECT creoleRuleClassID FROM CreoleRuleClass WHERE creoleRuleSetID not IN (SELECT creoleRuleSetID FROM CreoleRuleset));

-- Attribute availability records
DELETE FROM creoleAttributeAvailability WHERE creoleRuleClassID IN (
    -- disconnected class IDs
    SELECT creoleRuleClassID FROM CreoleRuleClass WHERE creoleRulesetID not IN (SELECT creoleRuleSetID FROM CreoleRuleset) );

-- attributes of disconnected classes:
DELETE FROM creoleRuleAttribute WHERE declaringRuleClassID IN (
  -- disconnected class IDs
  SELECT creoleRuleClassID FROM CreoleRuleClass WHERE creoleRulesetID not IN (SELECT creoleRuleSetID FROM CreoleRuleset) );

-- disconnected classes:
DELETE FROM CreoleRuleClass WHERE creoleRulesetID not IN (SELECT creoleRuleSetID FROM CreoleRuleset);


